/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.export;

import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWFileFilter;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeNode;

public class VWImportDialog
extends VWModalDialog
implements ActionListener,
DocumentListener,
Runnable {
    protected static final int STATUS_OK = 0;
    protected static final int STATUS_CANCEL = 1;
    private Frame m_parentFrame = null;
    private VWConfigRegionNode m_importRegiontNode = null;
    private int m_nRetStatus = -1;
    private JTextPane m_descriptionTextPane = null;
    private SimpleAttributeSet m_boldBlackText = null;
    private SimpleAttributeSet m_plainBlackText = null;
    private JTextField m_filePathTextField = new JTextField();
    private JLabel m_messageLabel = new JLabel();
    private JLabel m_startTimeLabel = new JLabel();
    private JLabel m_elapseTimeLabel = new JLabel();
    private JLabel m_regionLabel = new JLabel();
    private JLabel m_operationStatusLabel = new JLabel(VWResource.InProgress);
    private JButton m_closeButton = null;
    private JButton m_cancelButton = null;
    private JButton m_showDetailButton = null;
    private JButton m_helpButton = null;
    private JButton m_importButton = null;
    private JButton m_browseButton = null;
    private JButton m_currentDefaultButton = null;
    private JRadioButton m_replaceRadioButton = null;
    private JRadioButton m_mergeRadioButton = null;
    private ButtonGroup m_importOptionButtonGroup = new ButtonGroup();
    private JPanel m_instructionPanel = new JPanel();
    private JPanel m_processInfoPanel = new JPanel();
    private JPanel m_currentPanel = null;
    private JScrollPane m_scrollPane = null;
    private JTextArea m_messageTextArea = null;
    private Date m_startTime = null;
    private long m_lStartTimeMillis;
    private boolean m_bStopTimer = false;
    private String m_operationOutput = "";
    private Font aFont = this.getFont();
    private Font boldFont = new Font(this.aFont.getName(), 1, this.aFont.getSize());
    private boolean m_bSuccess = false;

    public VWImportDialog(Frame parent, VWConfigRegionNode rNode) {
        super(parent);
        try {
            this.setTitle(VWIDMBaseFactory.instance().getVWString(4).toString());
            this.m_parentFrame = parent;
            this.m_importRegiontNode = rNode;
            Dimension dim = VWStringUtils.stringToDimension("665,385");
            if (dim == null) {
                dim = new Dimension(600, 350);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.initControls();
            JPanel panel = new JPanel(new BorderLayout(10, 10));
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.createDescriptionPanel(VWResource.ImportConfigTitle, VWResource.ImportInstruction2), "First");
            VWAccessibilityHelper.setAccessibility(this.m_instructionPanel, panel, null, null);
            JPanel mainPanel = this.createMainPanel();
            panel.add((Component)mainPanel, "Center");
            VWAccessibilityHelper.setAccessibility(mainPanel, panel, null, null);
            panel.add((Component)this.createGeneralInfoButtonPanel(), "Last");
            this.getContentPane().add(panel);
            if (this.m_currentPanel != null) {
                this.getContentPane().remove(this.m_currentPanel);
            }
            this.m_currentPanel = panel;
            this.setLocationRelativeTo(this.m_parentFrame);
            this.setLocationRelativeTo(this.m_parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.setImportButtonState();
    }

    public void removeUpdate(DocumentEvent event) {
        this.setImportButtonState();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_closeButton || object == this.m_cancelButton) {
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc059.htm");
        } else if (object == this.m_showDetailButton) {
            Object image = null;
            if (this.m_bSuccess) {
                this.changeToSummaryInfoLayout(VWResource.Summary, VWResource.SuccessfullyImportFrom.toString(this.m_filePathTextField.getText()), this.m_operationOutput, this.m_bSuccess);
            } else {
                this.changeToSummaryInfoLayout(VWResource.Summary, VWResource.FailedImportFrom.toString(this.m_filePathTextField.getText()), this.m_operationOutput, this.m_bSuccess);
            }
        } else if (object == this.m_importButton) {
            int ret = VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.ImportWarning2, VWResource.Import, 3, 3, null, 0, 0);
            if (ret == 1) {
                this.changeToProgressInfoLayout();
                Thread elapsedTimeThread = new Thread(this);
                elapsedTimeThread.start();
                ImportThread ipThread = new ImportThread("VW Import Thread");
                ipThread.start();
            }
        } else if (object == this.m_browseButton) {
            this.showFileDialog();
            this.m_browseButton.requestFocus();
        }
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_importRegiontNode = null;
        if (this.m_descriptionTextPane != null) {
            this.m_descriptionTextPane.removeAll();
            this.m_descriptionTextPane = null;
        }
        if (this.m_filePathTextField != null) {
            this.m_filePathTextField.removeAll();
            this.m_filePathTextField = null;
        }
        if (this.m_messageLabel != null) {
            this.m_messageLabel.removeAll();
            this.m_messageLabel = null;
        }
        if (this.m_startTimeLabel != null) {
            this.m_startTimeLabel.removeAll();
            this.m_startTimeLabel = null;
        }
        if (this.m_elapseTimeLabel != null) {
            this.m_elapseTimeLabel.removeAll();
            this.m_elapseTimeLabel = null;
        }
        if (this.m_regionLabel != null) {
            this.m_regionLabel.removeAll();
            this.m_regionLabel = null;
        }
        if (this.m_operationStatusLabel != null) {
            this.m_operationStatusLabel.removeAll();
            this.m_operationStatusLabel = null;
        }
        if (this.m_showDetailButton != null) {
            this.m_showDetailButton.removeActionListener(this);
            this.m_showDetailButton.removeAll();
            this.m_showDetailButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_closeButton != null) {
            this.m_closeButton.removeActionListener(this);
            this.m_closeButton.removeAll();
            this.m_closeButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        if (this.m_importButton != null) {
            this.m_importButton.removeActionListener(this);
            this.m_importButton.removeAll();
            this.m_importButton = null;
        }
        if (this.m_browseButton != null) {
            this.m_browseButton.removeActionListener(this);
            this.m_browseButton.removeAll();
            this.m_browseButton = null;
        }
        if (this.m_importOptionButtonGroup != null) {
            this.m_importOptionButtonGroup.remove(this.m_replaceRadioButton);
            this.m_importOptionButtonGroup.remove(this.m_mergeRadioButton);
            this.m_importOptionButtonGroup = null;
        }
        this.m_currentPanel = null;
        this.m_replaceRadioButton = null;
        this.m_mergeRadioButton = null;
        this.m_startTime = null;
        this.m_operationOutput = null;
        this.aFont = null;
        this.boldFont = null;
        this.removeAll();
    }

    public void run() {
        try {
            String sHours = null;
            String sMinutes = null;
            String sSeconds = null;
            while (!this.m_bStopTimer) {
                long currentTimeMillis = System.currentTimeMillis();
                long elapsedTimeSeconds = (currentTimeMillis - this.m_lStartTimeMillis) / 1000L;
                int hours = (int)(elapsedTimeSeconds / 3600L);
                sHours = hours < 10 ? "0" + String.valueOf(hours) : String.valueOf(hours);
                int minutes = (int)((elapsedTimeSeconds %= 3600L) / 60L);
                sMinutes = minutes < 10 ? "0" + String.valueOf(minutes) : String.valueOf(minutes);
                int seconds = (int)(elapsedTimeSeconds % 60L);
                sSeconds = seconds < 10 ? "0" + String.valueOf(seconds) : String.valueOf(seconds);
                this.m_elapseTimeLabel.setText(VWResource.ElapseTimeFormat.toString(sHours, sMinutes, sSeconds));
                VWAccessibilityHelper.setAccessibility(this.m_elapseTimeLabel, this.m_processInfoPanel, this.m_elapseTimeLabel.getText(), this.m_elapseTimeLabel.getText());
                Thread.yield();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initControls() {
        this.m_importButton = new JButton(VWResource.Import);
        this.m_importButton.setEnabled(false);
        this.m_importButton.setFocusable(false);
        this.m_importButton.addActionListener(this);
        this.m_closeButton = new JButton(VWResource.s_close);
        this.m_closeButton.addActionListener(this);
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        this.m_cancelButton.addActionListener(this);
        this.m_showDetailButton = new JButton(VWResource.ShowDetail);
        this.m_showDetailButton.addActionListener(this);
        this.m_helpButton = new JButton(VWResource.s_help);
        this.m_helpButton.addActionListener(this);
        this.m_browseButton = new JButton(VWResource.s_browse);
        this.m_browseButton.addActionListener(this);
        this.m_regionLabel.setText(this.m_importRegiontNode.getRegionIDString());
        this.m_filePathTextField.getDocument().addDocumentListener(this);
        this.m_replaceRadioButton = new JRadioButton(VWResource.Overwrite);
        this.m_mergeRadioButton = new JRadioButton(VWResource.Merge);
        this.m_mergeRadioButton.setSelected(true);
        this.m_currentDefaultButton = this.m_browseButton;
    }

    private void changeToProgressInfoLayout() {
        Container mainContainer = this.getContentPane();
        mainContainer.removeAll();
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.updateInstruction(VWResource.ImportConfigTitle, VWResource.ImportProgressInstruction);
        panel.add((Component)this.m_instructionPanel, "First");
        VWAccessibilityHelper.setAccessibility(this.m_instructionPanel, panel, null, null);
        panel.add((Component)this.createProgressInfoPanel(), "Center");
        VWAccessibilityHelper.setAccessibility(this.m_processInfoPanel, panel, null, null);
        panel.add((Component)this.createProgressInfoButtonPanel(), "Last");
        this.getContentPane().add(panel);
        if (this.m_currentPanel != null) {
            this.getContentPane().remove(this.m_currentPanel);
        }
        this.m_currentPanel = panel;
        VWAccessibilityHelper.setAccessibility(panel, this, null, null);
        if (this.m_currentDefaultButton != null) {
            this.m_currentDefaultButton.requestFocus();
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void changeToSummaryInfoLayout(String titleStr, String InstructionStr, String summaryStr, boolean bSuccess) {
        Container mainContainer = this.getContentPane();
        mainContainer.removeAll();
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.updateInstruction(titleStr, InstructionStr);
        panel.add((Component)this.m_instructionPanel, "First");
        VWAccessibilityHelper.setAccessibility(this.m_instructionPanel, panel, null, null);
        JPanel summaryPanel = this.createSummaryInfoPanel(summaryStr, bSuccess);
        panel.add((Component)summaryPanel, "Center");
        VWAccessibilityHelper.setAccessibility(summaryPanel, panel, null, null);
        panel.add((Component)this.createSummaryInfoButtonPanel(), "Last");
        this.getContentPane().add(panel);
        if (this.m_currentPanel != null) {
            this.getContentPane().remove(this.m_currentPanel);
        }
        this.m_currentPanel = panel;
        VWAccessibilityHelper.setAccessibility(panel, this, null, null);
        if (this.m_currentDefaultButton != null) {
            this.m_currentDefaultButton.requestFocus();
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void updateInstruction(String title, String instructions) {
        try {
            if (this.m_descriptionTextPane != null) {
                this.m_descriptionTextPane.setText(null);
                Document descriptionDocument = this.m_descriptionTextPane.getDocument();
                descriptionDocument.insertString(descriptionDocument.getLength(), title + "\n", this.m_boldBlackText);
                descriptionDocument.insertString(descriptionDocument.getLength(), instructions, this.m_plainBlackText);
                VWAccessibilityHelper.setAccessibility(this.m_descriptionTextPane, this.m_instructionPanel, title, instructions);
                VWAccessibilityHelper.setAccessibility(this.m_instructionPanel, null, title, instructions);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createDescriptionPanel(String titleStr, String instructionStr) {
        try {
            ImageIcon image = VWImageLoader.createImageIcon("iso_logon_32.gif");
            this.m_instructionPanel.setLayout(new BoxLayout(this.m_instructionPanel, 2));
            this.m_instructionPanel.setBackground(SystemColor.text);
            this.m_instructionPanel.setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder));
            this.m_descriptionTextPane = new JTextPane();
            this.m_descriptionTextPane.setBackground(SystemColor.text);
            this.m_descriptionTextPane.setEditable(false);
            this.m_descriptionTextPane.setFocusable(false);
            this.m_boldBlackText = new SimpleAttributeSet();
            StyleConstants.setForeground(this.m_boldBlackText, SystemColor.textText);
            StyleConstants.setBold(this.m_boldBlackText, true);
            this.m_plainBlackText = new SimpleAttributeSet();
            StyleConstants.setForeground(this.m_plainBlackText, SystemColor.textText);
            StyleConstants.setBold(this.m_plainBlackText, false);
            this.m_descriptionTextPane.setText(null);
            Document descriptionDocument = this.m_descriptionTextPane.getDocument();
            descriptionDocument.insertString(descriptionDocument.getLength(), titleStr + "\n", this.m_boldBlackText);
            descriptionDocument.insertString(descriptionDocument.getLength(), instructionStr, this.m_plainBlackText);
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextPane, this.m_instructionPanel, titleStr, instructionStr);
            VWAccessibilityHelper.setAccessibility(this.m_instructionPanel, null, titleStr, instructionStr);
            this.m_descriptionTextPane.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_instructionPanel.add(Box.createRigidArea(new Dimension(15, 60)));
            this.m_instructionPanel.add(this.m_descriptionTextPane);
            if (image != null) {
                this.m_instructionPanel.add(new JLabel(image));
                this.m_instructionPanel.add(Box.createRigidArea(new Dimension(15, 60)));
            }
            this.m_instructionPanel.setFocusable(false);
            return this.m_instructionPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createImportTypePanel() {
        JPanel importTypePanel = new JPanel();
        try {
            importTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.ImportType));
            GridBagConstraints gbConst = new GridBagConstraints();
            importTypePanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.insets = new Insets(0, 10, 0, 10);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            importTypePanel.add((Component)this.m_mergeRadioButton, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            importTypePanel.add((Component)this.m_replaceRadioButton, gbConst);
            VWAccessibilityHelper.setAccessibility(importTypePanel, this, VWResource.ImportType, VWResource.ImportType);
            VWAccessibilityHelper.setAccessibility(this.m_mergeRadioButton, importTypePanel, VWResource.Merge, VWResource.Merge);
            VWAccessibilityHelper.setAccessibility(this.m_replaceRadioButton, importTypePanel, VWResource.Overwrite, VWResource.Overwrite);
            VWAccessibilityHelper.setMemberOf(this.m_mergeRadioButton, this.m_importOptionButtonGroup);
            VWAccessibilityHelper.setMemberOf(this.m_replaceRadioButton, this.m_importOptionButtonGroup);
            this.m_mergeRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_replaceRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return importTypePanel;
    }

    private JPanel createMainPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel();
            GridBagConstraints gbConst = new GridBagConstraints();
            panel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.insets = new Insets(10, 10, 10, 10);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel IsolatedRegionLabel = new JLabel(VWResource.s_label.toString(VWResource.IsolatedRegion));
            panel.add((Component)IsolatedRegionLabel, gbConst);
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            panel.add((Component)this.m_regionLabel, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            JLabel filePathLabel = new JLabel(VWResource.s_label.toString(VWResource.ImportFile));
            panel.add((Component)filePathLabel, gbConst);
            ++gbConst.gridx;
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            panel.add((Component)this.m_filePathTextField, gbConst);
            ++gbConst.gridx;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            panel.add((Component)this.m_browseButton, gbConst);
            gbConst.insets = new Insets(0, 10, 0, 10);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            panel.add((Component)this.createImportTypePanel(), gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 1;
            gbConst.weighty = 1.0;
            gbConst.weightx = 1.0;
            panel.add((Component)new JLabel(), gbConst);
            VWAccessibilityHelper.setAccessibility(IsolatedRegionLabel, panel, VWResource.IsolatedRegion, VWResource.IsolatedRegion);
            VWAccessibilityHelper.setAccessibility(this.m_regionLabel, panel, this.m_importRegiontNode.getRegionIDString(), this.m_importRegiontNode.getRegionIDString());
            VWAccessibilityHelper.setAccessibility(filePathLabel, panel, VWResource.ImportFile, VWResource.ImportFile);
            VWAccessibilityHelper.setAccessibility(filePathLabel, panel, VWResource.ImportFile, VWResource.ImportFile);
            VWAccessibilityHelper.setAccessibility(this.m_filePathTextField, panel, VWResource.SpecifyImportFilePath, VWResource.SpecifyImportFilePath);
            VWAccessibilityHelper.setAccessibility(this.m_browseButton, panel, VWResource.Browse, VWResource.Browse);
            VWAccessibilityHelper.setLabelFor(filePathLabel, this.m_filePathTextField);
            this.m_filePathTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_browseButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel createProgressInfoPanel() {
        try {
            GridBagConstraints gbConst = new GridBagConstraints();
            this.m_processInfoPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.insets = new Insets(10, 10, 10, 10);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            JLabel IsolatedRegionLabel = new JLabel(VWResource.s_label.toString(VWResource.IsolatedRegion));
            this.m_processInfoPanel.add((Component)IsolatedRegionLabel, gbConst);
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            this.m_processInfoPanel.add((Component)this.m_regionLabel, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel startTimeLabel = new JLabel(VWResource.s_label.toString(VWResource.StartTime));
            this.m_processInfoPanel.add((Component)startTimeLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            DateFormat df = DateFormat.getDateTimeInstance(2, 3);
            this.m_startTime = new Date();
            this.m_lStartTimeMillis = System.currentTimeMillis();
            this.m_startTimeLabel.setText(df.format(this.m_startTime));
            this.m_processInfoPanel.add((Component)this.m_startTimeLabel, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            JLabel elapseTimeLabel = new JLabel(VWResource.s_label.toString(VWResource.ElapsedTime));
            this.m_processInfoPanel.add((Component)elapseTimeLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            this.m_elapseTimeLabel.setText(VWResource.ElapseTimeFormat.toString("00", "00", "00"));
            this.m_processInfoPanel.add((Component)this.m_elapseTimeLabel, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            JLabel statusLable = new JLabel(VWResource.s_label.toString(VWResource.s_status));
            this.m_processInfoPanel.add((Component)statusLable, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            this.m_processInfoPanel.add((Component)this.m_operationStatusLabel, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 1;
            gbConst.weighty = 1.0;
            gbConst.weightx = 1.0;
            this.m_processInfoPanel.add((Component)new JLabel(), gbConst);
            VWAccessibilityHelper.setAccessibility(IsolatedRegionLabel, this.m_processInfoPanel, VWResource.IsolatedRegion, VWResource.IsolatedRegion);
            VWAccessibilityHelper.setAccessibility(this.m_regionLabel, this.m_processInfoPanel, this.m_importRegiontNode.getRegionIDString(), this.m_importRegiontNode.getRegionIDString());
            VWAccessibilityHelper.setAccessibility(startTimeLabel, this.m_processInfoPanel, VWResource.StartTime, VWResource.StartTime);
            VWAccessibilityHelper.setAccessibility(this.m_startTimeLabel, this.m_processInfoPanel, this.m_startTimeLabel.getText(), this.m_startTimeLabel.getText());
            VWAccessibilityHelper.setAccessibility(elapseTimeLabel, this.m_processInfoPanel, VWResource.ElapsedTime, VWResource.ElapsedTime);
            VWAccessibilityHelper.setAccessibility(this.m_elapseTimeLabel, this.m_processInfoPanel, this.m_elapseTimeLabel.getText(), this.m_elapseTimeLabel.getText());
            VWAccessibilityHelper.setAccessibility(statusLable, this.m_processInfoPanel, VWResource.s_status, VWResource.s_status);
            VWAccessibilityHelper.setAccessibility(this.m_operationStatusLabel, this.m_processInfoPanel, this.m_operationStatusLabel.getText(), this.m_operationStatusLabel.getText());
            this.m_processInfoPanel.applyComponentOrientation(this.m_parentFrame.getComponentOrientation());
            return this.m_processInfoPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createSummaryInfoPanel(String summaryStr, boolean bSuccess) {
        JPanel panel = null;
        try {
            panel = new JPanel();
            this.m_messageTextArea = new JTextArea();
            this.m_messageTextArea.setText(summaryStr);
            this.m_messageTextArea.setCaretPosition(0);
            this.m_messageTextArea.setLineWrap(true);
            this.m_messageTextArea.setWrapStyleWord(true);
            this.m_messageTextArea.setEditable(false);
            this.m_messageTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            Color bgColor = panel.getBackground();
            this.m_messageTextArea.setBackground(bgColor);
            Font boldFont = null;
            Font normalFont = this.getFont();
            if (normalFont != null) {
                boldFont = new Font(normalFont.getName(), 1, normalFont.getSize());
            }
            this.m_messageTextArea.setFont(boldFont);
            GridBagConstraints gbCons = new GridBagConstraints();
            panel.setLayout(new GridBagLayout());
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            Icon image = null;
            image = bSuccess ? UIManager.getIcon("OptionPane.informationIcon") : UIManager.getIcon("OptionPane.errorIcon");
            if (image != null) {
                gbCons.fill = 0;
                gbCons.weightx = 0.0;
                gbCons.weighty = 0.0;
                JLabel iconLabel = new JLabel(image);
                panel.add((Component)iconLabel, gbCons);
                ++gbCons.gridx;
            }
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_scrollPane = new JScrollPane(this.m_messageTextArea);
            this.m_scrollPane.setBorder(null);
            panel.add((Component)this.m_scrollPane, gbCons);
            panel.setBorder(BorderFactory.createLineBorder(panel.getBackground()));
            if (bSuccess) {
                VWAccessibilityHelper.setAccessibility(this.m_messageTextArea, panel, VWResource.Summary, summaryStr);
                VWAccessibilityHelper.setAccessibility(panel, null, VWResource.Summary, summaryStr);
            } else {
                VWAccessibilityHelper.setAccessibility(this.m_messageTextArea, panel, VWResource.Error, summaryStr);
                VWAccessibilityHelper.setAccessibility(panel, null, VWResource.Error, summaryStr);
            }
            this.m_messageTextArea.setFocusable(false);
            this.m_messageTextArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_messageTextArea.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (e != null && e.getSource() != null && e.getSource() instanceof JTextArea) {
                        Container parent = ((JTextArea)e.getSource()).getParent();
                        while (parent != null && !(parent instanceof JScrollPane)) {
                            if (!(parent instanceof JComponent)) continue;
                            parent = ((JComponent)parent).getParent();
                        }
                        if (parent != null && parent instanceof JScrollPane && (parent = ((JScrollPane)parent).getParent()) != null && parent instanceof JPanel) {
                            ((JPanel)parent).setBorder(BorderFactory.createLineBorder(((JPanel)parent).getForeground()));
                        }
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (e != null && e.getSource() != null && e.getSource() instanceof JTextArea) {
                        Container parent = ((JTextArea)e.getSource()).getParent();
                        while (parent != null && !(parent instanceof JScrollPane)) {
                            if (!(parent instanceof JComponent)) continue;
                            parent = ((JComponent)parent).getParent();
                        }
                        if (parent != null && parent instanceof JScrollPane && (parent = ((JScrollPane)parent).getParent()) != null && parent instanceof JPanel) {
                            ((JPanel)parent).setBorder(BorderFactory.createLineBorder(((JPanel)parent).getBackground()));
                        }
                    }
                }
            });
            JScrollBar scrollBar = this.m_scrollPane.getVerticalScrollBar();
            scrollBar.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (e.getSource() != null && e.getSource() instanceof JScrollBar) {
                        JScrollBar sb = (JScrollBar)e.getSource();
                        boolean bFocusable = sb.getMaximum() != sb.getVisibleAmount();
                        for (Container parent = sb.getParent(); parent != null; parent = parent.getParent()) {
                            if (!(parent instanceof JPanel)) continue;
                            parent.setFocusable(bFocusable);
                            VWImportDialog.this.m_messageTextArea.setFocusable(bFocusable);
                            break;
                        }
                    }
                }
            });
            panel.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    VWImportDialog.this.m_messageTextArea.requestFocus();
                }

                public void focusLost(FocusEvent e) {
                }
            });
            panel.applyComponentOrientation(this.m_parentFrame.getComponentOrientation());
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createGeneralInfoButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new FlowLayout());
            panel.add(this.m_importButton);
            panel.add(this.m_cancelButton);
            panel.add(this.m_helpButton);
            VWAccessibilityHelper.setAccessibility(this.m_importButton, panel, VWResource.s_import, VWResource.s_import);
            this.m_importButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, panel, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, panel, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_importButton.requestFocus();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    protected JPanel createProgressInfoButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new FlowLayout());
            this.m_showDetailButton.setEnabled(false);
            this.m_closeButton.setEnabled(false);
            this.m_showDetailButton.setFocusable(false);
            this.m_closeButton.setFocusable(false);
            panel.add(this.m_showDetailButton);
            panel.add(this.m_closeButton);
            VWAccessibilityHelper.setAccessibility(this.m_showDetailButton, panel, VWResource.s_details, VWResource.s_details);
            this.m_showDetailButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_closeButton, panel, VWResource.s_close, VWResource.s_close);
            this.m_closeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_closeButton.requestFocus();
            this.m_currentDefaultButton = this.m_closeButton;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    protected JPanel createSummaryInfoButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new FlowLayout());
            this.m_closeButton.setEnabled(true);
            this.m_closeButton.setFocusable(true);
            panel.add(this.m_closeButton);
            VWAccessibilityHelper.setAccessibility(this.m_closeButton, panel, VWResource.s_close, VWResource.s_close);
            this.m_closeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_closeButton.requestFocus();
            this.m_currentDefaultButton = this.m_closeButton;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_currentDefaultButton != null) {
            this.m_currentDefaultButton.requestFocus();
        }
    }

    protected int getStatus() {
        return this.m_nRetStatus;
    }

    private void setImportButtonState() {
        String tempString;
        if (this.m_importButton == null) {
            return;
        }
        boolean bEnable = false;
        if (this.m_filePathTextField != null && (tempString = this.m_filePathTextField.getText()) != null) {
            tempString.trim();
            if (tempString.length() > 0) {
                bEnable = true;
            }
        }
        if (this.m_importButton.isEnabled() != bEnable) {
            this.m_importButton.setEnabled(bEnable);
            this.m_importButton.setFocusable(bEnable);
        }
    }

    private void showFileDialog() {
        FileDialog importFileDialog = new FileDialog(this.m_parentFrame, VWResource.Import, 0);
        importFileDialog.setFilenameFilter(new VWFileFilter(".xml"));
        importFileDialog.setFile(".xml");
        importFileDialog.setVisible(true);
        String filePath = importFileDialog.getDirectory();
        String fileName = importFileDialog.getFile();
        if (filePath != null && fileName != null) {
            File file = new File(filePath + fileName);
            if (file.exists()) {
                this.m_filePathTextField.setText(filePath + fileName);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.InvalidImportFile.toString(file.getPath()), VWResource.ErrorMessage, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processImport() {
        try {
            try {
                this.m_regionLabel.setText(this.m_importRegiontNode.getRegionIDString());
                this.setCursor(Cursor.getPredefinedCursor(3));
                String importXMLFile = this.m_filePathTextField.getText();
                int importOption = 1;
                if (this.m_mergeRadioButton.isSelected()) {
                    importOption = 2;
                }
                this.m_operationOutput = this.m_importRegiontNode.fromXML(importXMLFile, importOption);
                this.m_importRegiontNode.refresh(true);
                TreeNode parentNode = this.m_importRegiontNode.getParent();
                if (parentNode != null && parentNode instanceof VWConfigVWServiceNode) {
                    VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)parentNode;
                    sNode.setSysAdmin(this.m_importRegiontNode.getSession().fetchSystemAdministration());
                }
                this.m_operationStatusLabel.setText(VWResource.Success);
                VWAccessibilityHelper.setAccessibility(this.m_operationStatusLabel, this.m_processInfoPanel, this.m_operationStatusLabel.getText(), this.m_operationStatusLabel.getText());
                this.m_closeButton.setEnabled(true);
                this.m_closeButton.setFocusable(true);
                this.m_closeButton.requestFocus();
                this.m_showDetailButton.setEnabled(true);
                this.m_showDetailButton.setFocusable(true);
                this.m_bSuccess = true;
            }
            catch (Exception ex) {
                this.m_bSuccess = false;
                this.m_showDetailButton.setEnabled(true);
                this.m_closeButton.setFocusable(true);
                this.m_closeButton.setEnabled(true);
                this.m_showDetailButton.setFocusable(true);
                this.m_closeButton.setFocusable(true);
                this.m_operationStatusLabel.setText(VWResource.s_error);
                this.m_operationStatusLabel.setForeground(Color.red);
                this.m_operationOutput = VWResource.s_label.toString(VWResource.VWService) + this.m_importRegiontNode.getServiceName() + "\n" + VWResource.s_label.toString(VWResource.Region) + this.m_importRegiontNode.getRegionIDString() + "\n" + ex.getLocalizedMessage();
                VWDebug.logException(ex);
                Object var6_7 = null;
                this.m_bStopTimer = true;
                this.m_closeButton.setEnabled(true);
                this.m_closeButton.setFocusable(true);
                this.m_closeButton.requestFocus();
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            Object var6_6 = null;
            this.m_bStopTimer = true;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_bStopTimer = true;
            this.m_closeButton.setEnabled(true);
            this.m_closeButton.setFocusable(true);
            this.m_closeButton.requestFocus();
            this.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.m_closeButton.setEnabled(true);
        this.m_closeButton.setFocusable(true);
        this.m_closeButton.requestFocus();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    class ImportThread
    extends Thread {
        public ImportThread(String theName) {
            super(theName);
        }

        public void run() {
            VWImportDialog.this.processImport();
            VWImportDialog.this.m_bStopTimer = true;
        }
    }
}

